<?php
/**
 * JavaScript Challenge Verification Endpoint
 * Verifies that the client is a real browser executing JavaScript
 */
session_start();

header('Content-Type: application/json');
header('Cache-Control: no-store');

// Only accept POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['ok' => false, 'error' => 'method']);
    exit;
}

$challenge_key = $_POST['challenge_key'] ?? '';
$answer = $_POST['answer'] ?? '';
$fp_data = $_POST['fp'] ?? '';

// Verify challenge exists in session
if (empty($_SESSION['js_challenge'])) {
    echo json_encode(['ok' => false, 'error' => 'no_challenge']);
    exit;
}

$challenge = $_SESSION['js_challenge'];

// Verify the answer matches
$expected = md5($challenge['key'] . $challenge['time'] . 'dhl_shield_v3');

// Check timing - must respond within reasonable time
$elapsed = time() - $challenge['time'];
if ($elapsed > 60) {
    echo json_encode(['ok' => false, 'error' => 'expired']);
    exit;
}

if ($answer === $expected && $challenge_key === $challenge['key']) {
    // Challenge passed!
    $_SESSION['js_verified'] = true;
    $_SESSION['js_verify_time'] = time();
    
    // Store fingerprint
    if (!empty($fp_data)) {
        $fp = @json_decode($fp_data, true);
        if ($fp) {
            $_SESSION['client_fp'] = $fp;
            
            // Check for headless browser indicators in fingerprint
            if (!empty($fp['headless']) || !empty($fp['virtual'])) {
                $_SESSION['js_verified'] = false;
                echo json_encode(['ok' => false, 'error' => 'env']);
                exit;
            }
        }
    }
    
    // Generate verification token
    $token = bin2hex(random_bytes(16));
    $_SESSION['verify_token'] = $token;
    
    echo json_encode(['ok' => true, 'token' => $token]);
} else {
    echo json_encode(['ok' => false, 'error' => 'invalid']);
}
?>
