<?php
session_start();
date_default_timezone_set("UTC");

require __DIR__ . '/app.php';
require __DIR__ . '/shield.php';
require __DIR__ . '/detect.php';
require __DIR__ . '/lang.php';

$detect = new Mobile_Detect;
if (strtolower($block_pc) == "on" && !$detect->isMobile()) {
    exit;
}

// Auto-detect language
$lang = detectLanguage();
$t = getTranslations($lang);
$dir = in_array($lang, ['ar', 'he', 'fa', 'ur']) ? 'rtl' : 'ltr';

// Auto-detect currency based on IP/country
$currency = detectCurrency();
$currency_symbol = $currency['symbol'];
$currency_code = $currency['code'];
$currency_amount = $currency['amount'];

// Generate JS Challenge key
$js_challenge_key = Shield::generateJSChallenge();

// Generate CSRF form token
$form_token = Shield::generateFormToken();

?>
