<?php
/**
 * Cover Page - Legitimate Education Platform
 * This page is shown to bots, crawlers, and direct visitors
 * It looks like a completely normal education website
 */
$site_name = "EduPlus Learning Platform";
$year = date('Y');
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $site_name; ?> - Online Courses & Professional Development</title>
    <meta name="description" content="EduPlus offers professional online courses, certifications, and skill development programs. Learn at your own pace with expert instructors.">
    <meta name="keywords" content="online courses, education, learning, professional development, certifications, skills training">
    <meta name="author" content="EduPlus Learning">
    <meta name="robots" content="index, follow">
    <meta property="og:title" content="EduPlus Learning Platform - Online Courses">
    <meta property="og:description" content="Professional online courses and certifications for career growth.">
    <meta property="og:type" content="website">
    <link rel="canonical" href="https://<?php echo $_SERVER['HTTP_HOST']; ?>/">
    <style>
        *{margin:0;padding:0;box-sizing:border-box}
        :root{--primary:#2563eb;--primary-dark:#1d4ed8;--secondary:#059669;--bg:#f8fafc;--text:#1e293b;--text-light:#64748b;--white:#ffffff;--border:#e2e8f0;--shadow:0 1px 3px rgba(0,0,0,.1)}
        body{font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,'Helvetica Neue',Arial,sans-serif;background:var(--bg);color:var(--text);line-height:1.6}
        a{text-decoration:none;color:var(--primary)}
        .container{max-width:1200px;margin:0 auto;padding:0 20px}
        
        /* Header */
        .header{background:var(--white);border-bottom:1px solid var(--border);padding:16px 0;position:sticky;top:0;z-index:100}
        .header-inner{display:flex;align-items:center;justify-content:space-between}
        .logo{font-size:24px;font-weight:700;color:var(--primary)}
        .logo span{color:var(--secondary)}
        .nav{display:flex;gap:24px;align-items:center}
        .nav a{color:var(--text);font-weight:500;font-size:15px;transition:color .2s}
        .nav a:hover{color:var(--primary)}
        .btn{display:inline-block;padding:10px 24px;border-radius:8px;font-weight:600;font-size:14px;transition:all .2s;cursor:pointer;border:none}
        .btn-primary{background:var(--primary);color:var(--white)}
        .btn-primary:hover{background:var(--primary-dark)}
        .btn-outline{border:2px solid var(--primary);color:var(--primary);background:transparent}
        
        /* Hero */
        .hero{padding:80px 0;text-align:center;background:linear-gradient(135deg,#eff6ff 0%,#f0fdf4 100%)}
        .hero h1{font-size:48px;font-weight:800;margin-bottom:20px;line-height:1.2}
        .hero h1 span{color:var(--primary)}
        .hero p{font-size:20px;color:var(--text-light);max-width:600px;margin:0 auto 30px}
        .hero-stats{display:flex;justify-content:center;gap:60px;margin-top:40px}
        .stat{text-align:center}
        .stat-num{font-size:36px;font-weight:800;color:var(--primary)}
        .stat-label{font-size:14px;color:var(--text-light);margin-top:4px}
        
        /* Courses */
        .section{padding:60px 0}
        .section-title{text-align:center;margin-bottom:40px}
        .section-title h2{font-size:32px;font-weight:700;margin-bottom:10px}
        .section-title p{color:var(--text-light);font-size:18px}
        .courses-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(280px,1fr));gap:24px}
        .course-card{background:var(--white);border-radius:12px;overflow:hidden;box-shadow:var(--shadow);transition:transform .2s,box-shadow .2s}
        .course-card:hover{transform:translateY(-4px);box-shadow:0 8px 25px rgba(0,0,0,.1)}
        .course-img{height:160px;background:linear-gradient(135deg,var(--primary),var(--secondary));display:flex;align-items:center;justify-content:center;color:var(--white);font-size:48px}
        .course-body{padding:20px}
        .course-body h3{font-size:18px;margin-bottom:8px}
        .course-body p{font-size:14px;color:var(--text-light);margin-bottom:12px}
        .course-meta{display:flex;justify-content:space-between;align-items:center;font-size:13px;color:var(--text-light)}
        .course-price{font-weight:700;color:var(--secondary);font-size:16px}
        .badge{display:inline-block;padding:4px 10px;border-radius:20px;font-size:12px;font-weight:600;background:#dbeafe;color:var(--primary)}
        
        /* Features */
        .features{background:var(--white);padding:60px 0}
        .features-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(250px,1fr));gap:30px}
        .feature{text-align:center;padding:30px 20px}
        .feature-icon{width:60px;height:60px;border-radius:16px;background:linear-gradient(135deg,#eff6ff,#dbeafe);display:flex;align-items:center;justify-content:center;margin:0 auto 16px;font-size:28px}
        .feature h3{font-size:18px;margin-bottom:8px}
        .feature p{font-size:14px;color:var(--text-light)}
        
        /* Testimonials */
        .testimonials{padding:60px 0}
        .testimonial-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(300px,1fr));gap:24px}
        .testimonial{background:var(--white);padding:24px;border-radius:12px;box-shadow:var(--shadow)}
        .testimonial-text{font-style:italic;margin-bottom:16px;color:var(--text)}
        .testimonial-author{display:flex;align-items:center;gap:12px}
        .author-avatar{width:40px;height:40px;border-radius:50%;background:var(--primary);color:var(--white);display:flex;align-items:center;justify-content:center;font-weight:700}
        .author-info{font-size:14px}
        .author-info strong{display:block}
        .author-info span{color:var(--text-light)}
        
        /* CTA */
        .cta{background:linear-gradient(135deg,var(--primary),var(--primary-dark));color:var(--white);padding:60px 0;text-align:center}
        .cta h2{font-size:32px;margin-bottom:12px}
        .cta p{font-size:18px;opacity:.9;margin-bottom:24px}
        .cta .btn{background:var(--white);color:var(--primary);font-size:16px;padding:14px 32px}
        
        /* Footer */
        .footer{background:#1e293b;color:#94a3b8;padding:40px 0}
        .footer-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(200px,1fr));gap:30px;margin-bottom:30px}
        .footer h4{color:var(--white);margin-bottom:12px;font-size:16px}
        .footer a{color:#94a3b8;display:block;margin-bottom:8px;font-size:14px}
        .footer a:hover{color:var(--white)}
        .footer-bottom{border-top:1px solid #334155;padding-top:20px;text-align:center;font-size:13px}
        
        @media(max-width:768px){
            .hero h1{font-size:32px}
            .hero-stats{flex-direction:column;gap:20px}
            .nav{display:none}
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="container header-inner">
            <div class="logo">Edu<span>Plus</span></div>
            <nav class="nav">
                <a href="#">Courses</a>
                <a href="#">Programs</a>
                <a href="#">For Business</a>
                <a href="#">Resources</a>
                <a href="#" class="btn btn-outline">Sign In</a>
                <a href="#" class="btn btn-primary">Get Started</a>
            </nav>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <h1>Unlock Your <span>Potential</span><br>With Expert-Led Courses</h1>
            <p>Join thousands of professionals advancing their careers with our industry-recognized certification programs.</p>
            <a href="#" class="btn btn-primary" style="font-size:16px;padding:14px 32px">Explore Courses</a>
            <div class="hero-stats">
                <div class="stat"><div class="stat-num">50K+</div><div class="stat-label">Active Students</div></div>
                <div class="stat"><div class="stat-num">200+</div><div class="stat-label">Expert Courses</div></div>
                <div class="stat"><div class="stat-num">95%</div><div class="stat-label">Satisfaction Rate</div></div>
                <div class="stat"><div class="stat-num">40+</div><div class="stat-label">Countries</div></div>
            </div>
        </div>
    </section>

    <section class="section">
        <div class="container">
            <div class="section-title">
                <h2>Popular Courses</h2>
                <p>Start learning from our most popular programs</p>
            </div>
            <div class="courses-grid">
                <div class="course-card">
                    <div class="course-img">&#128187;</div>
                    <div class="course-body">
                        <span class="badge">Bestseller</span>
                        <h3>Full-Stack Web Development</h3>
                        <p>Master HTML, CSS, JavaScript, React, Node.js and more in this comprehensive bootcamp.</p>
                        <div class="course-meta"><span>12 weeks &bull; 48 lessons</span><span class="course-price">$299</span></div>
                    </div>
                </div>
                <div class="course-card">
                    <div class="course-img">&#128202;</div>
                    <div class="course-body">
                        <span class="badge">New</span>
                        <h3>Data Science & Analytics</h3>
                        <p>Learn Python, SQL, machine learning, and data visualization from industry experts.</p>
                        <div class="course-meta"><span>10 weeks &bull; 36 lessons</span><span class="course-price">$249</span></div>
                    </div>
                </div>
                <div class="course-card">
                    <div class="course-img">&#127912;</div>
                    <div class="course-body">
                        <span class="badge">Popular</span>
                        <h3>UX/UI Design Masterclass</h3>
                        <p>Create stunning user interfaces and experiences with Figma, Adobe XD, and design thinking.</p>
                        <div class="course-meta"><span>8 weeks &bull; 32 lessons</span><span class="course-price">$199</span></div>
                    </div>
                </div>
                <div class="course-card">
                    <div class="course-img">&#128274;</div>
                    <div class="course-body">
                        <span class="badge">Certification</span>
                        <h3>Cybersecurity Fundamentals</h3>
                        <p>Protect systems and networks with ethical hacking, penetration testing, and security protocols.</p>
                        <div class="course-meta"><span>14 weeks &bull; 52 lessons</span><span class="course-price">$349</span></div>
                    </div>
                </div>
                <div class="course-card">
                    <div class="course-img">&#128640;</div>
                    <div class="course-body">
                        <span class="badge">Advanced</span>
                        <h3>Digital Marketing Pro</h3>
                        <p>SEO, SEM, social media marketing, content strategy, and analytics for business growth.</p>
                        <div class="course-meta"><span>6 weeks &bull; 24 lessons</span><span class="course-price">$179</span></div>
                    </div>
                </div>
                <div class="course-card">
                    <div class="course-img">&#129302;</div>
                    <div class="course-body">
                        <span class="badge">Trending</span>
                        <h3>AI & Machine Learning</h3>
                        <p>Deep learning, neural networks, NLP, and computer vision with TensorFlow and PyTorch.</p>
                        <div class="course-meta"><span>16 weeks &bull; 60 lessons</span><span class="course-price">$399</span></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="features">
        <div class="container">
            <div class="section-title">
                <h2>Why Choose EduPlus?</h2>
                <p>Everything you need for professional growth</p>
            </div>
            <div class="features-grid">
                <div class="feature">
                    <div class="feature-icon">&#127891;</div>
                    <h3>Expert Instructors</h3>
                    <p>Learn from industry professionals with years of real-world experience.</p>
                </div>
                <div class="feature">
                    <div class="feature-icon">&#128218;</div>
                    <h3>Flexible Learning</h3>
                    <p>Study at your own pace with lifetime access to course materials.</p>
                </div>
                <div class="feature">
                    <div class="feature-icon">&#127942;</div>
                    <h3>Certifications</h3>
                    <p>Earn industry-recognized certificates to boost your career.</p>
                </div>
                <div class="feature">
                    <div class="feature-icon">&#129309;</div>
                    <h3>Community Support</h3>
                    <p>Join a global community of learners and mentors.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="testimonials">
        <div class="container">
            <div class="section-title">
                <h2>What Our Students Say</h2>
                <p>Real stories from real learners</p>
            </div>
            <div class="testimonial-grid">
                <div class="testimonial">
                    <p class="testimonial-text">"EduPlus completely transformed my career. The web development course helped me land my dream job at a top tech company."</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">S</div>
                        <div class="author-info"><strong>Sarah Mitchell</strong><span>Software Engineer at Google</span></div>
                    </div>
                </div>
                <div class="testimonial">
                    <p class="testimonial-text">"The data science program was incredibly well-structured. I went from zero to getting a data analyst role in just 4 months."</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">J</div>
                        <div class="author-info"><strong>James Rodriguez</strong><span>Data Analyst at Amazon</span></div>
                    </div>
                </div>
                <div class="testimonial">
                    <p class="testimonial-text">"Best investment I've made in my education. The instructors are world-class and the content is always up-to-date."</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">A</div>
                        <div class="author-info"><strong>Aisha Patel</strong><span>UX Designer at Microsoft</span></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="cta">
        <div class="container">
            <h2>Ready to Start Learning?</h2>
            <p>Join 50,000+ professionals who are already advancing their careers with EduPlus.</p>
            <a href="#" class="btn">Start Free Trial</a>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div>
                    <h4>EduPlus</h4>
                    <a href="#">About Us</a>
                    <a href="#">Careers</a>
                    <a href="#">Press</a>
                    <a href="#">Blog</a>
                </div>
                <div>
                    <h4>Courses</h4>
                    <a href="#">Web Development</a>
                    <a href="#">Data Science</a>
                    <a href="#">Design</a>
                    <a href="#">Marketing</a>
                </div>
                <div>
                    <h4>Support</h4>
                    <a href="#">Help Center</a>
                    <a href="#">Contact Us</a>
                    <a href="#">FAQ</a>
                    <a href="#">Community</a>
                </div>
                <div>
                    <h4>Legal</h4>
                    <a href="#">Terms of Service</a>
                    <a href="#">Privacy Policy</a>
                    <a href="#">Cookie Policy</a>
                    <a href="#">Accessibility</a>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo $year; ?> EduPlus Learning Platform. All rights reserved.</p>
            </div>
        </div>
    </footer>
</body>
</html>
