<?php
session_start();

/**
 * Security Dashboard - Admin Panel
 */

$admin_pass = 'admin123'; // Change in production!

// Logout
if (isset($_GET['out'])) {
    unset($_SESSION['adm']);
    header('location: index.php');
    exit;
}

// Login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pw'])) {
    if ($_POST['pw'] === $admin_pass) {
        $_SESSION['adm'] = true;
    } else {
        $error = 'Incorrect password';
    }
}

// Show login if not authenticated
if (empty($_SESSION['adm'])) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    <title>Panel</title>
    <style>
        *{margin:0;padding:0;box-sizing:border-box}
        body{font-family:'Inter',sans-serif;background:#1a1a2e;min-height:100vh;display:flex;align-items:center;justify-content:center}
        .login{background:#16213e;padding:40px;border-radius:12px;width:100%;max-width:380px;box-shadow:0 20px 60px rgba(0,0,0,0.3)}
        h1{color:#FFCC00;text-align:center;margin-bottom:30px;font-size:1.4rem}
        label{display:block;color:#8892b0;margin-bottom:8px;font-size:0.85rem;font-weight:600}
        input{width:100%;padding:12px;border:2px solid #233554;border-radius:6px;background:#0a192f;color:#ccd6f6;font-size:1rem;outline:none}
        input:focus{border-color:#FFCC00}
        button{width:100%;padding:12px;background:#D40511;color:#fff;border:none;border-radius:6px;font-size:1rem;font-weight:700;cursor:pointer;margin-top:20px}
        button:hover{background:#b8040e}
        .err{color:#D40511;text-align:center;margin-bottom:16px;font-size:0.9rem}
    </style>
</head>
<body>
    <div class="login">
        <h1>Security Panel</h1>
        <?php if(isset($error)): ?><div class="err"><?php echo $error; ?></div><?php endif; ?>
        <form method="POST">
            <label>Password</label>
            <input type="password" name="pw" required autofocus>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
<?php exit; }

// ===== Dashboard =====
$storage = __DIR__ . '/../storage/';
$access_log = $storage . 'access.log';
$alerts_log = $storage . 'alerts.log';
$blocked_log = $storage . 'blocked.log';

$access = []; $alerts = []; $blocked = [];

if (file_exists($access_log)) {
    $lines = array_reverse(file($access_log));
    foreach (array_slice($lines, 0, 200) as $l) {
        $d = json_decode($l, true);
        if ($d) $access[] = $d;
    }
}
if (file_exists($alerts_log)) {
    $lines = array_reverse(file($alerts_log));
    foreach (array_slice($lines, 0, 200) as $l) {
        $d = json_decode($l, true);
        if ($d) $alerts[] = $d;
    }
}
if (file_exists($blocked_log)) {
    $lines = array_reverse(file($blocked_log));
    foreach (array_slice($lines, 0, 200) as $l) {
        $d = json_decode($l, true);
        if ($d) $blocked[] = $d;
    }
}

$total_access = count($access);
$total_alerts = count($alerts);
$total_blocked = count($blocked);
$security_rate = $total_access > 0 ? round((1 - ($total_alerts + $total_blocked) / max($total_access, 1)) * 100) : 100;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    <title>Security Dashboard</title>
    <style>
        *{margin:0;padding:0;box-sizing:border-box}
        body{font-family:'Inter',sans-serif;background:#0a192f;color:#ccd6f6;padding:20px}
        .wrap{max-width:1400px;margin:0 auto}
        .top-bar{display:flex;justify-content:space-between;align-items:center;margin-bottom:30px}
        h1{color:#FFCC00;font-size:1.5rem}
        .logout{color:#D40511;text-decoration:none;font-weight:600;padding:8px 16px;border:1px solid #D40511;border-radius:6px;font-size:0.85rem}
        .logout:hover{background:#D40511;color:#fff}
        .stats{display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:16px;margin-bottom:30px}
        .stat{background:#16213e;padding:24px;border-radius:10px;border-left:4px solid #FFCC00}
        .stat h3{color:#8892b0;font-size:0.8rem;text-transform:uppercase;letter-spacing:1px;margin-bottom:8px}
        .stat .num{font-size:2rem;font-weight:700;color:#ccd6f6}
        .stat.danger{border-left-color:#D40511}
        .stat.success{border-left-color:#28a745}
        .section{background:#16213e;border-radius:10px;padding:20px;margin-bottom:20px;overflow-x:auto}
        .section h2{color:#FFCC00;font-size:1.1rem;margin-bottom:16px;padding-bottom:10px;border-bottom:1px solid #233554}
        table{width:100%;border-collapse:collapse;font-size:0.82rem}
        th{background:#0a192f;color:#FFCC00;padding:10px;text-align:left;font-weight:600;white-space:nowrap}
        td{padding:10px;border-bottom:1px solid #233554;color:#8892b0;max-width:300px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}
        tr:hover td{background:#1a2744}
        .badge{padding:3px 8px;border-radius:4px;font-size:0.75rem;font-weight:600}
        .badge-red{background:#D4051133;color:#D40511}
        .badge-yellow{background:#FFCC0033;color:#FFCC00}
        .badge-green{background:#28a74533;color:#28a745}
        .empty{text-align:center;color:#555;padding:40px;font-size:0.9rem}
    </style>
</head>
<body>
<div class="wrap">
    <div class="top-bar">
        <h1>Security Dashboard</h1>
        <a href="?out=1" class="logout">Logout</a>
    </div>
    
    <div class="stats">
        <div class="stat">
            <h3>Total Requests</h3>
            <div class="num"><?php echo $total_access; ?></div>
        </div>
        <div class="stat danger">
            <h3>Suspicious Activities</h3>
            <div class="num"><?php echo $total_alerts; ?></div>
        </div>
        <div class="stat danger">
            <h3>Blocked Requests</h3>
            <div class="num"><?php echo $total_blocked; ?></div>
        </div>
        <div class="stat success">
            <h3>Security Rate</h3>
            <div class="num"><?php echo $security_rate; ?>%</div>
        </div>
    </div>

    <div class="section">
        <h2>Blocked Requests (Last 200)</h2>
        <?php if(!empty($blocked)): ?>
        <table>
            <thead><tr><th>Time</th><th>IP</th><th>Reason</th><th>User-Agent</th></tr></thead>
            <tbody>
            <?php foreach(array_slice($blocked,0,50) as $b): ?>
            <tr>
                <td><?php echo htmlspecialchars($b['time'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($b['ip'] ?? ''); ?></td>
                <td><span class="badge badge-red"><?php echo htmlspecialchars($b['extra']['reason'] ?? ''); ?></span></td>
                <td><?php echo htmlspecialchars(substr($b['ua'] ?? '',0,60)); ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?><div class="empty">No blocked requests</div><?php endif; ?>
    </div>

    <div class="section">
        <h2>Suspicious Activities (Last 200)</h2>
        <?php if(!empty($alerts)): ?>
        <table>
            <thead><tr><th>Time</th><th>IP</th><th>Indicators</th><th>User-Agent</th></tr></thead>
            <tbody>
            <?php foreach(array_slice($alerts,0,50) as $a): ?>
            <tr>
                <td><?php echo htmlspecialchars($a['time'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($a['ip'] ?? ''); ?></td>
                <td><span class="badge badge-yellow"><?php echo htmlspecialchars($a['extra']['reason'] ?? json_encode($a['extra'] ?? [])); ?></span></td>
                <td><?php echo htmlspecialchars(substr($a['ua'] ?? '',0,60)); ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?><div class="empty">No suspicious activities</div><?php endif; ?>
    </div>

    <div class="section">
        <h2>Recent Access (Last 50)</h2>
        <?php if(!empty($access)): ?>
        <table>
            <thead><tr><th>Time</th><th>IP</th><th>Type</th><th>URI</th><th>User-Agent</th></tr></thead>
            <tbody>
            <?php foreach(array_slice($access,0,50) as $a): ?>
            <tr>
                <td><?php echo htmlspecialchars($a['time'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($a['ip'] ?? ''); ?></td>
                <td><span class="badge badge-green"><?php echo htmlspecialchars($a['type'] ?? ''); ?></span></td>
                <td><?php echo htmlspecialchars($a['uri'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars(substr($a['ua'] ?? '',0,50)); ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?><div class="empty">No access logs</div><?php endif; ?>
    </div>
</div>
</body>
</html>
